/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.lsys;

import javax.xml.bind.JAXBElement;
import junit.framework.TestCase;
import kandid.calculation.lsys.LsysMashine;
import kandid.soup.EntityType;
import kandid.soup.LsysILChromosome;
import kandid.soup.util.SoupFactory;

public class LsysILCalculationTest
extends TestCase {
    static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entity version=\"0.1.3\">    <lsysIL version=\"0.2.7\" rating=\"abort\">        <calculationName>kandid.calculation.lsys.LsysCalculation</calculationName>        <coloratorName>kandid.colorator.BlackWhiteColorator</coloratorName>        <chromosome>            <ident>LsysIL_a_2</ident>";
    static final String footer = "        </chromosome>    </lsysIL></entity>";
    private SoupFactory soupFactory = SoupFactory.getSoupFactory();

    public LsysILCalculationTest(String name) {
        super(name);
    }

    private static String buildProduction(String axiom, String[] predecessor, String[] successor, String[] leftContext, String[] rightContext, int depth) {
        String ret = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entity version=\"0.1.3\">    <lsysIL version=\"0.2.7\" rating=\"abort\">        <calculationName>kandid.calculation.lsys.LsysCalculation</calculationName>        <coloratorName>kandid.colorator.BlackWhiteColorator</coloratorName>        <chromosome>            <ident>LsysIL_a_2</ident>            <alphabet>                <value>FAB-+</value>            </alphabet>            <axiom>                <value>" + axiom + "</value>            </axiom>";
        assert (predecessor.length == successor.length);
        int ip = 0;
        while (ip < predecessor.length) {
            ret = ret + "            <production>                <predecessor>                    <value>" + predecessor[ip] + "</value>                </predecessor>                <successor>                    <value>" + successor[ip] + "</value>                </successor>                <leftContext>                    <value>" + leftContext[ip] + "</value>                </leftContext>                <rightContext>                    <value>" + rightContext[ip] + "</value>                </rightContext>            </production>";
            ++ip;
        }
        ret = ret + "            <directions>                <value>4</value>            </directions>            <baseIndex>                <value>10</value>            </baseIndex>            <ignore>                <value></value>            </ignore>            <depth>                <value>" + depth + "</value>            </depth>            <jitter>                <value>10</value>            </jitter>            <noiseSeed>                <value>1512</value>            </noiseSeed>        </chromosome>    </lsysIL></entity>";
        return ret;
    }

    private LsysILChromosome buildChromosome(String axiom, String[] predecessor, String[] successor, String[] leftContext, String[] rightContext, int depth) {
        String production = LsysILCalculationTest.buildProduction(axiom, predecessor, successor, leftContext, rightContext, depth);
        JAXBElement uo = (JAXBElement)this.soupFactory.unmarshalFromString(production);
        EntityType entity = (EntityType)uo.getValue();
        LsysILChromosome lsysILChromosome = entity.getLsysIL().getChromosome();
        return lsysILChromosome;
    }

    private String executeProduction(String axiom, String[] predecessor, String[] successor, String[] leftContext, String[] rightContext, int depth) {
        System.out.println("----\n");
        LsysILChromosome lsysILChromosome = this.buildChromosome(axiom, predecessor, successor, leftContext, rightContext, depth);
        LsysMashine.testInitCalculation(lsysILChromosome);
        LsysMashine.expand(lsysILChromosome.getDepth().getValue());
        byte[] result = LsysMashine.string;
        StringBuffer ret = new StringBuffer(LsysMashine.length);
        int rx = 0;
        while (rx < LsysMashine.length) {
            ret.append((char)result[rx]);
            ++rx;
        }
        System.out.println(ret.toString());
        return ret.toString();
    }

    public void testExpand() {
        String axiom = "F";
        String[] predecessor = new String[]{"F", "F"};
        String[] leftContext = new String[]{"", ""};
        String[] rightContext = new String[]{"", ""};
        String[] successor = new String[]{"-", "FF-[-F+F+F]+[+F-F-F]"};
        LsysILCalculationTest.assertEquals((String)"FF-[-F+F+F]+[+F-F-F]--[-FF-[-F+F+F]+[+F-F-F]+-+FF-[-F+F+F]+[+F-F-F]]+[+--FF-[-F+F+F]+[+F-F-F]-FF-[-F+F+F]+[+F-F-F]]", (String)this.executeProduction(axiom, predecessor, successor, leftContext, rightContext, 2));
        axiom = "BAAAAAAAA";
        predecessor = new String[]{"A", "B"};
        leftContext = new String[]{"B", ""};
        rightContext = new String[]{"", ""};
        successor = new String[]{"B", "A"};
        LsysILCalculationTest.assertEquals((String)"ABAAAAAAA", (String)this.executeProduction(axiom, predecessor, successor, leftContext, rightContext, 1));
        LsysILCalculationTest.assertEquals((String)"AAAAAAAAB", (String)this.executeProduction(axiom, predecessor, successor, leftContext, rightContext, 8));
    }
}

