/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.lsys;

import javax.xml.bind.JAXBElement;
import junit.framework.TestCase;
import kandid.calculation.lsys.LsysMashine;
import kandid.soup.EntityType;
import kandid.soup.LsysD0LChromosome;
import kandid.soup.genetic.lsys.LsysGenetic;
import kandid.soup.util.SoupFactory;

public class LsysD0LCalculationTest
extends TestCase {
    static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entity version=\"0.1.3\">    <lsysD0L version=\"0.2.7\" rating=\"abort\">        <calculationName>kandid.calculation.lsys.LsysCalculation</calculationName>        <coloratorName>kandid.colorator.BlackWhiteColorator</coloratorName>        <chromosome>            <ident>Lsys_dqhq698a_dqhq6992</ident>";
    static final String footer = "        </chromosome>    </lsysD0L></entity>";
    private SoupFactory soupFactory = SoupFactory.getSoupFactory();

    public LsysD0LCalculationTest(String name) {
        super(name);
    }

    public static String buildProduction(String axiom, String[] predecessor, String[] successor, int depth) {
        String ret = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entity version=\"0.1.3\">    <lsysD0L version=\"0.2.7\" rating=\"abort\">        <calculationName>kandid.calculation.lsys.LsysCalculation</calculationName>        <coloratorName>kandid.colorator.BlackWhiteColorator</coloratorName>        <chromosome>            <ident>Lsys_dqhq698a_dqhq6992</ident>            <alphabet>                <value>F-+-</value>            </alphabet>            <axiom>                <value>" + axiom + "</value>            </axiom>";
        assert (predecessor.length == successor.length);
        int ip = 0;
        while (ip < predecessor.length) {
            ret = ret + "            <production>                <predecessor>                    <value>" + predecessor[ip] + "</value>                </predecessor>                <successor>                    <value>" + successor[ip] + "</value>                </successor>            </production>";
            ++ip;
        }
        ret = ret + "            <directions>                <value>4</value>            </directions>            <baseIndex>                <value>10</value>            </baseIndex>            <depth>                <value>" + depth + "</value>            </depth>        </chromosome>    </lsysD0L></entity>";
        return ret;
    }

    private LsysD0LChromosome buildChromosome(String axiom, String[] predecessor, String[] successor, int depth) {
        String production = LsysD0LCalculationTest.buildProduction(axiom, predecessor, successor, depth);
        JAXBElement uo = (JAXBElement)this.soupFactory.unmarshalFromString(production);
        EntityType entity = (EntityType)uo.getValue();
        LsysD0LChromosome lsysD0LChromosome = entity.getLsysD0L().getChromosome();
        return lsysD0LChromosome;
    }

    private String executeProduction(String axiom, String[] predecessor, String[] successor, int depth) {
        System.out.println("----\n");
        LsysD0LChromosome lsysD0LChromosome = this.buildChromosome(axiom, predecessor, successor, depth);
        LsysMashine.testInitCalculation(lsysD0LChromosome);
        LsysMashine.expand(lsysD0LChromosome.getDepth().getValue());
        byte[] result = LsysMashine.string;
        StringBuffer ret = new StringBuffer(LsysMashine.length);
        int rx = 0;
        while (rx < LsysMashine.length) {
            ret.append((char)result[rx]);
            ++rx;
        }
        System.out.println(ret.toString());
        return ret.toString();
    }

    public void testErzeugePflanze() {
        String[] predecessor = new String[]{"F"};
        String[] successor = new String[]{"FF-[-F+F+F]+[+F-F-F]"};
        LsysD0LCalculationTest.assertEquals((String)"F", (String)this.executeProduction("F", predecessor, successor, 0));
        LsysD0LCalculationTest.assertEquals((String)"FF-[-F+F+F]+[+F-F-F]", (String)this.executeProduction("F", predecessor, successor, 1));
        LsysD0LCalculationTest.assertEquals((String)"FF-[-F+F+F]+[+F-F-F]FF-[-F+F+F]+[+F-F-F]-[-FF-[-F+F+F]+[+F-F-F]+FF-[-F+F+F]+[+F-F-F]+FF-[-F+F+F]+[+F-F-F]]+[+FF-[-F+F+F]+[+F-F-F]-FF-[-F+F+F]+[+F-F-F]-FF-[-F+F+F]+[+F-F-F]]", (String)this.executeProduction("F", predecessor, successor, 2));
        predecessor = new String[]{"F"};
        successor = new String[]{"FF-[-F+F+F]+[+F-F-F]"};
        LsysD0LCalculationTest.assertFalse((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 0)));
    }

    public void testReject() {
        String[] predecessor = new String[]{"F"};
        String[] successor = new String[]{"FF-[-F+F+F]+[+F-F-F]"};
        LsysD0LCalculationTest.assertFalse((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 1)));
        predecessor = new String[]{"F", "+"};
        successor = new String[]{"FF-[-F+F+F]+[+F-F-F]", "-"};
        LsysD0LCalculationTest.assertFalse((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 1)));
        predecessor = new String[]{"F", "F"};
        successor = new String[]{"FF-[-F+F+F]+[+F-F-F]", "-"};
        LsysD0LCalculationTest.assertTrue((boolean)LsysGenetic.reject(this.buildChromosome("F", predecessor, successor, 1)));
    }
}

