/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.lca;

import java.util.List;
import kandid.calculation.lca.LcaCalculation;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.DirectLcaChromosome;
import kandid.soup.LcaStateGene;

public class DirectLcaCalculation
extends LcaCalculation
implements Cloneable {
    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        DirectLcaChromosome lcaChromosome = (DirectLcaChromosome)chromosome;
        this.maxStates = lcaChromosome.getMaxStates().getValue();
        this.size = this.width * this.width;
        this.totalDisplayRows = this.width;
        this.actDisplayRow = 0;
        this.neighbors = lcaChromosome.getLeftNeighbors().getValue() + 1 + lcaChromosome.getRightNeighbors().getValue();
        this.state = new int[this.width];
        this.setRandomFirstState();
        this.nextState = new int[this.width];
        List<LcaStateGene> ruleList = lcaChromosome.getRule();
        this.rule = new int[ruleList.size()];
        int px = 0;
        while (px < this.rule.length) {
            this.rule[px] = ruleList.get(px).getValue();
            ++px;
        }
        this.intPalette = new ColorF32[lcaChromosome.getColor().size()];
        List<ColorGene> colorList = lcaChromosome.getColor();
        int px2 = 0;
        while (px2 < this.intPalette.length) {
            this.intPalette[px2] = new ColorF32();
            colorator.getColor(colorList.get(px2), this.intPalette[px2]);
            ++px2;
        }
    }

    public static int numberofRules(int maxStates, int leftNeighbors, int rightNeighbors) {
        int nr = 1;
        int nb = leftNeighbors + 1 + rightNeighbors;
        int ix = 0;
        while (ix < nb) {
            nr *= maxStates;
            ++ix;
        }
        return nr;
    }

    @Override
    protected int getRuleNumber(int index, int maxStates) {
        int ruleNumber = 0;
        int nx = 0;
        while (nx < this.neighbors) {
            ruleNumber *= maxStates;
            ruleNumber += this.state[(index + nx) % this.state.length];
            ++nx;
        }
        return ruleNumber;
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }
}

