/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge.povray;

import java.util.List;
import kandid.soup.ExprSdlArgsListGene;
import kandid.soup.ExprSdlConstGene;
import kandid.soup.ExprSdlListGene;
import kandid.soup.ExprSdlOprBase;
import kandid.soup.ExprSdlOprGene;
import kandid.soup.ExprSdlVarBase;
import kandid.soup.ExprSdlVarGene;
import kandid.soup.GeneType;
import kandid.soup.SdlExpressionGene;

public class SdlExport {
    public StringBuffer generateSDLFunction(ExprSdlListGene exprSdlListGene) {
        StringBuffer sdl = new StringBuffer();
        sdl.append("function(x,y,z) { ");
        sdl.append(this.compile0(exprSdlListGene));
        sdl.append(" }");
        return sdl;
    }

    private StringBuffer compile0(ExprSdlListGene exprSdlListGene) {
        StringBuffer sdl = new StringBuffer();
        sdl.append("(");
        ExprSdlOprGene opr = exprSdlListGene.getOpr();
        ExprSdlArgsListGene args = exprSdlListGene.getArgs();
        List<GeneType> argsList = args.getVarOrConstOrSdlExpression();
        int argsLen = argsList.size();
        assert (argsLen > 0) : "argument list to short " + argsLen;
        if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ADD)) {
            int ax = 0;
            while (ax < argsLen) {
                sdl.append(this.compileElement(argsList.get(ax)));
                if (ax + 1 < argsLen) {
                    sdl.append("+");
                }
                ++ax;
            }
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.MULT)) {
            int ax = 0;
            while (ax < argsLen) {
                sdl.append(this.compileElement(argsList.get(ax)));
                if (ax + 1 < argsLen) {
                    sdl.append("*");
                }
                ++ax;
            }
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.SUB)) {
            int ax = 0;
            while (ax < argsLen) {
                sdl.append(this.compileElement(argsList.get(ax)));
                if (ax + 1 < argsLen) {
                    sdl.append("-");
                }
                ++ax;
            }
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.DIV)) {
            int ax = 0;
            while (ax < argsLen) {
                sdl.append(this.compileElement(argsList.get(ax)));
                if (ax + 1 < argsLen) {
                    sdl.append("/");
                }
                ++ax;
            }
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.MAX)) {
            sdl.append("max(");
            int ax = 0;
            while (ax < argsLen) {
                sdl.append(this.compileElement(argsList.get(ax)));
                if (ax + 1 < argsLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.MIN)) {
            sdl.append("min(");
            int ax = 0;
            while (ax < argsLen) {
                sdl.append(this.compileElement(argsList.get(ax)));
                if (ax + 1 < argsLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.MOD)) {
            int fixedLen = 2;
            sdl.append("mod(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.NOISE)) {
            int fixedLen = 3;
            sdl.append("f_noise3d(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.SNOISE)) {
            int fixedLen = 3;
            sdl.append("f_snoise3d(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ATANQ)) {
            int fixedLen = 2;
            sdl.append("atan2(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.POW)) {
            int fixedLen = 2;
            sdl.append("pow(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.SQRT)) {
            int fixedLen = 1;
            sdl.append("sqrt(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.POW)) {
            int fixedLen = 2;
            sdl.append("pow(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ABS)) {
            int fixedLen = 1;
            sdl.append("abs(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ACOS)) {
            int fixedLen = 1;
            sdl.append("acos(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ACOSH)) {
            int fixedLen = 1;
            sdl.append("acosh(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ASIN)) {
            int fixedLen = 1;
            sdl.append("asin(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ASINH)) {
            int fixedLen = 1;
            sdl.append("asinh(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ATAN)) {
            int fixedLen = 1;
            sdl.append("atan(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.ATANH)) {
            int fixedLen = 1;
            sdl.append("atanh(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.CEIL)) {
            int fixedLen = 1;
            sdl.append("ceil(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.COS)) {
            int fixedLen = 1;
            sdl.append("cos(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.COSH)) {
            int fixedLen = 1;
            sdl.append("cosh(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.DEGREES)) {
            int fixedLen = 1;
            sdl.append("degrees(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.EXP)) {
            int fixedLen = 1;
            sdl.append("exp(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.FLOOR)) {
            int fixedLen = 1;
            sdl.append("floor(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.LN)) {
            int fixedLen = 1;
            sdl.append("ln(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.LOG)) {
            int fixedLen = 1;
            sdl.append("log(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.RADIANS)) {
            int fixedLen = 1;
            sdl.append("radians(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.SIN)) {
            int fixedLen = 1;
            sdl.append("sin(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.SINH)) {
            int fixedLen = 1;
            sdl.append("sinh(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.SQRT)) {
            int fixedLen = 1;
            sdl.append("sqrt(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.TAN)) {
            int fixedLen = 1;
            sdl.append("tan(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else if (opr.getSdlOpr().equals((Object)ExprSdlOprBase.TANH)) {
            int fixedLen = 1;
            sdl.append("tanh(");
            int ax = 0;
            while (ax < fixedLen) {
                sdl.append(this.compileElement(argsList.get(ax % argsList.size())));
                if (ax + 1 < fixedLen) {
                    sdl.append(",");
                }
                ++ax;
            }
            sdl.append(")");
        } else assert (false) : "invalid operator " + String.valueOf((Object)opr.getSdlOpr());
        sdl.append(")");
        return sdl;
    }

    private StringBuffer compileElement(Object obj) {
        StringBuffer sdl = new StringBuffer();
        if (obj instanceof ExprSdlVarGene) {
            ExprSdlVarGene var = (ExprSdlVarGene)obj;
            if (var.getSdlVar().equals((Object)ExprSdlVarBase.X)) {
                sdl.append(" x");
            } else if (var.getSdlVar().equals((Object)ExprSdlVarBase.Y)) {
                sdl.append(" y");
            } else if (var.getSdlVar().equals((Object)ExprSdlVarBase.Z)) {
                sdl.append(" z");
            }
        } else if (obj instanceof ExprSdlConstGene) {
            ExprSdlConstGene aConst = (ExprSdlConstGene)obj;
            sdl.append(" " + String.valueOf(aConst.getSdlConst().getValue()));
        } else if (obj instanceof SdlExpressionGene) {
            SdlExpressionGene sdlExpressionArg = (SdlExpressionGene)obj;
            sdl.append(this.compile0(sdlExpressionArg.getList()));
        } else assert (false) : "invalid object generating SDL expression" + obj.getClass().getName();
        return sdl;
    }
}

