/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge.povray;

import java.awt.image.BufferedImage;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.calculation.bridge.StreamBridge;
import kandid.calculation.bridge.povray.PovJob;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public class PovTextureCalculation
extends PixelBridgeCalculation {
    private BufferedImage importedPreviewImage;

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        this.importedPreviewImage = null;
    }

    @Override
    protected void calculateView() {
        this.calculateStreamingView();
    }

    private synchronized void calculateStreamingView() {
        if (!this.aborted && this.runCount < 2) {
            PovJob job = null;
            try {
                ++this.runCount;
                job = new PovJob();
                job.createJob(this.chromosome, this.canvasSize, this.runCount == 1, null, "png");
                job.importedImage = this.importedPreviewImage;
                this.bbridge = new StreamBridge(job);
                this.bbridge.execute();
                boolean ready = false;
                do {
                    ready = this.bbridge.recieve(this.bufAwtImg.getGraphics());
                    this.viewComponent.repaint();
                } while (!ready);
                this.bbridge.waitFor();
                if (job.state != 3) {
                    ready = this.bbridge.recieve(this.bufAwtImg.getGraphics());
                    this.viewComponent.repaint();
                }
                this.bbridge.cleanUp();
                if (this.runCount == 1) {
                    this.importedPreviewImage = job.importedImage;
                }
            }
            catch (Exception exc) {
                if (job != null) {
                    System.err.println(job.imageFileName);
                }
                Debug.stackTrace(exc);
            }
            this.ready = this.runCount >= 2;
        }
        this.bbridge = null;
    }

    @Override
    public void calculateExport(String exportFilename) {
        PovJob job = new PovJob();
        job.createJob(this.chromosome, this.canvasSize, false, exportFilename, "png");
        this.bbridge = new StreamBridge(job);
        this.bbridge.execute();
        this.bbridge.waitFor();
        this.bbridge = null;
        this.ready = true;
    }
}

