/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge.povray;

import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import kandid.Kandid;
import kandid.calculation.bridge.BatchJob;
import kandid.calculation.bridge.povray.SdlExport;
import kandid.colorator.ColorF32;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorMapEntryGene;
import kandid.soup.HsbftGene;
import kandid.soup.Matrix4X3Gene;
import kandid.soup.NormalMapEntryGene;
import kandid.soup.PovBlackHoleWarpGene;
import kandid.soup.PovBlendGene;
import kandid.soup.PovFinishGene;
import kandid.soup.PovIsoSurfaceChromosome;
import kandid.soup.PovNormalGene;
import kandid.soup.PovPigmentGene;
import kandid.soup.PovReflectionGene;
import kandid.soup.PovRidgedMultifractalGene;
import kandid.soup.PovRotateGene;
import kandid.soup.PovTextureLayerGene;
import kandid.soup.PovThingChromosome;
import kandid.soup.PovThingNFChromosome;
import kandid.soup.PovTransformMapGene;
import kandid.soup.PovTurbulenceWarpGene;
import kandid.soup.PovWarpGene;
import kandid.soup.util.ChromosomeStamp;

public class PovJob
extends BatchJob {
    @Override
    protected String[] buildEnvironment() {
        return null;
    }

    @Override
    protected String[] buildCommand() {
        assert (this.imageFormat.equals("png") || this.imageFormat.equals("")) : "unsupported image format " + this.imageFormat;
        String[] command = new String[]{this.childProgram, "+I" + this.scriptFileName, this.doExport ? "+O" + this.imageFileName : "+O-", "+W" + this.canvasSize.width / (this.preview ? 3 : 1), "+H" + this.canvasSize.height / (this.preview ? 3 : 1), "+Q9", "-V", this.doExport ? "+FN" : "+FT", "Debug_Console=Off", "Fatal_Console=On", "Render_Console=Off", "Statistic_Console=Off", "Warning_Console=On", "Display=Off"};
        return command;
    }

    @Override
    protected String getProgramName() {
        return "povray";
    }

    @Override
    protected String getScriptExtension() {
        return ".pov";
    }

    protected static double[] normalizeColorMap(List colorMap) {
        Iterator iter = colorMap.iterator();
        int size = colorMap.size() - 1;
        double[] segmentStart = new double[size];
        ColorMapEntryGene colorMapEntryGene = (ColorMapEntryGene)iter.next();
        double sum = colorMapEntryGene.getWeight().getValue();
        int ix = 0;
        while (iter.hasNext()) {
            colorMapEntryGene = (ColorMapEntryGene)iter.next();
            segmentStart[ix] = sum;
            sum += colorMapEntryGene.getWeight().getValue().doubleValue();
            ++ix;
        }
        ix = 0;
        while (ix < size) {
            int n = ix++;
            segmentStart[n] = segmentStart[n] / sum;
        }
        return segmentStart;
    }

    protected static double[] normalizeColorMap01(List aMap) {
        Iterator iter = aMap.iterator();
        int size = aMap.size();
        double[] segmentStart = new double[size];
        double sum = 0.0;
        int ix = 0;
        while (iter.hasNext()) {
            Object aEntry = iter.next();
            double weight = 1.0;
            if (aEntry instanceof ColorMapEntryGene) {
                weight = ((ColorMapEntryGene)aEntry).getWeight().getValue();
            } else if (aEntry instanceof NormalMapEntryGene) {
                weight = ((NormalMapEntryGene)aEntry).getWeight().getValue();
            } else assert (false) : "invalid type " + aEntry.getClass().getName();
            segmentStart[ix] = sum;
            if (ix + 1 < segmentStart.length) {
                sum += weight;
            }
            ++ix;
        }
        ix = 0;
        while (ix < size) {
            int n = ix++;
            segmentStart[n] = segmentStart[n] / sum;
        }
        return segmentStart;
    }

    private String exBlend(String script, PovBlendGene blend) {
        script = (String)script + "        " + blend.getBlendMapModifier().value() + "\n";
        script = (String)script + "        frequency " + String.valueOf(blend.getBlendMapFrequency().getValue()) + "\n";
        script = (String)script + "        phase " + String.valueOf(blend.getBlendMapPhase().getValue()) + "\n";
        return script;
    }

    private String exColor(String script, HsbftGene rgbftGene) {
        ColorF32 hsb = new ColorF32((float)rgbftGene.getHue().doubleValue(), (float)rgbftGene.getSaturation().doubleValue(), (float)rgbftGene.getBrightness().doubleValue());
        ColorF32 rgb = new ColorF32();
        ColorF32.hsb2rgb(hsb, rgb);
        script = (String)script + " rgbft <" + rgb.r + ", " + rgb.g + ", " + rgb.b + ", " + String.valueOf(rgbftGene.getFilter().getValue()) + ", " + String.valueOf(rgbftGene.getTransmit().getValue()) + "> ";
        return script;
    }

    @Override
    protected String expandScript(ChromosomeType chromosome) {
        PovIsoSurfaceChromosome povIsoSurfaceChromosome;
        String ident = ChromosomeStamp.removeType(chromosome.getIdent());
        PovThingChromosome povThingChromosome = (PovThingChromosome)chromosome;
        Object script = "";
        script = (String)script + "// Script for Persistence Of Vision raytracer version 3.7.\n";
        script = (String)script + "// Generated by Kandid version 1.1.0\n";
        script = (String)script + "// https://metagrowing.org/\n";
        script = (String)script + "//\n";
        script = (String)script + "#declare Texture1_" + ident + " =\n";
        List<PovTextureLayerGene> textureLayerList = povThingChromosome.getTextureLayer();
        assert (textureLayerList.size() >= 2);
        for (PovTextureLayerGene povTextureLayerGene : textureLayerList) {
            script = (String)script + "  texture {\n";
            PovPigmentGene pigment = povTextureLayerGene.getPigment();
            script = (String)script + "      pigment {\n";
            if (pigment == null) {
                script = (String)script + "        rgb <1, 1, 1>\n";
            } else {
                script = (String)script + "        " + pigment.getColorMap().getMapPattern().value() + "\n";
                script = (String)script + "        color_map {\n";
                List<ColorMapEntryGene> colorMapList = pigment.getColorMap().getColor();
                double[] segmentStart = PovJob.normalizeColorMap01(colorMapList);
                int cmx = 0;
                Iterator<ColorMapEntryGene> colorMapIter = colorMapList.iterator();
                while (cmx < segmentStart.length && colorMapIter.hasNext()) {
                    ColorMapEntryGene colorMapEntryGene = colorMapIter.next();
                    script = (String)script + "        [ " + segmentStart[cmx];
                    script = this.exColor((String)script, colorMapEntryGene.getHsbft());
                    script = (String)script + "]\n";
                    ++cmx;
                }
                script = (String)script + "        }\n";
                script = this.exWarp((String)script, pigment.getWarp());
                script = this.exTransform((String)script, pigment.getTransform());
                script = (String)script + "        noise_generator 3\n";
                script = this.exBlend((String)script, pigment.getBlend());
            }
            script = (String)script + "      }\n";
            script = (String)script + "    }\n";
        }
        script = (String)script + "\n";
        PovNormalGene normal = null;
        if (povThingChromosome instanceof PovThingNFChromosome && (normal = ((PovThingNFChromosome)povThingChromosome).getNormal()) != null) {
            script = (String)script + "#declare Normal1_" + ident + " =\n";
            script = (String)script + "   normal {\n";
            script = normal.getNormalMap().getAverage().isValue() != false ? (String)script + "     average\n" : (String)script + "     " + normal.getNormalMap().getMapPattern().value() + "\n";
            script = (String)script + "     normal_map {\n";
            List<NormalMapEntryGene> normalMapList = normal.getNormalMap().getNormal();
            double[] segmentStart = PovJob.normalizeColorMap01(normalMapList);
            int nmx = 0;
            Iterator<NormalMapEntryGene> normalMapIter = normalMapList.iterator();
            while (nmx < segmentStart.length && normalMapIter.hasNext()) {
                NormalMapEntryGene normalMapEntryGene = normalMapIter.next();
                script = (String)script + "     [ " + segmentStart[nmx] + " " + normalMapEntryGene.getMapPattern().value() + " " + String.valueOf(normalMapEntryGene.getDepth().getValue()) + " bump_size " + String.valueOf(normalMapEntryGene.getBumpSize().getValue()) + "\n";
                script = this.exWarp((String)script, normalMapEntryGene.getWarp());
                script = this.exTransform((String)script, normalMapEntryGene.getTransform());
                script = (String)script + "     noise_generator 3\n";
                script = (String)script + "     ]\n";
                ++nmx;
            }
            script = (String)script + "     }\n";
            script = this.exWarp((String)script, normal.getWarp());
            script = this.exTransform((String)script, normal.getTransform());
            script = (String)script + "     noise_generator 3\n";
            script = this.exBlend((String)script, normal.getBlend());
            script = (String)script + "   }\n";
        }
        PovFinishGene finish = null;
        if (povThingChromosome instanceof PovThingNFChromosome && (finish = ((PovThingNFChromosome)povThingChromosome).getFinish()) != null) {
            script = (String)script + "#declare Finish1_" + ident + " =\n";
            script = (String)script + "  finish {\n";
            script = (String)script + "    ambient " + String.valueOf(finish.getAmbient().getValue()) + "\n";
            script = (String)script + "    diffuse " + String.valueOf(finish.getDiffuse().getValue()) + "\n";
            script = (String)script + "    specular " + String.valueOf(finish.getSpecular().getValue()) + "\n";
            script = (String)script + "    roughness " + String.valueOf(finish.getRoughness().getValue()) + "\n";
            if (finish.getMetallic().isValue().booleanValue()) {
                script = (String)script + "    metallic\n";
            }
            PovReflectionGene reflection = finish.getReflection();
            script = (String)script + "    reflection {\n";
            script = "    " + this.exColor((String)script, reflection.getColor()) + "\n";
            if (reflection.getMetallic().isValue().booleanValue()) {
                script = (String)script + "      metallic\n";
            }
            script = (String)script + "    }\n";
            script = (String)script + "    conserve_energy\n";
            script = (String)script + "  }\n";
        }
        script = (String)script + "\n";
        script = (String)script + "global_settings {\n";
        script = (String)script + "   assumed_gamma 1.5\n";
        script = (String)script + "}\n";
        script = (String)script + "\n";
        if (povThingChromosome instanceof PovIsoSurfaceChromosome) {
            povIsoSurfaceChromosome = (PovIsoSurfaceChromosome)povThingChromosome;
            script = (String)script + "#declare f_ridged_mf = function { internal(59) }\n";
            script = (String)script + "#declare f_noise3d = function { internal(76) }\n";
            script = (String)script + "#declare f_snoise3d = function {2*f_noise3d(x, y, z) - 1}\n";
            script = (String)script + "\n";
            PovRidgedMultifractalGene ridgedMultifractal = povIsoSurfaceChromosome.getRidgedMultifractal();
            script = (String)script + "#declare fx_" + ident + " = ";
            script = (String)script + String.valueOf(new SdlExport().generateSDLFunction(ridgedMultifractal.getFx()));
            script = (String)script + "\n";
            script = (String)script + "#declare fy_" + ident + " = ";
            script = (String)script + String.valueOf(new SdlExport().generateSDLFunction(ridgedMultifractal.getFy()));
            script = (String)script + "\n";
            script = (String)script + "#declare fz_" + ident + " = ";
            script = (String)script + String.valueOf(new SdlExport().generateSDLFunction(ridgedMultifractal.getFz()));
            script = (String)script + "\n";
            script = (String)script + "#declare Thing_1 = isosurface {\n";
            script = (String)script + "  function { f_ridged_mf(fx_" + ident + "(x, y, z), fy_" + ident + "(x, y, z), fz_" + ident + "(x, y, z), ";
            script = (String)script + String.valueOf(ridgedMultifractal.getH().getValue()) + ", ";
            script = (String)script + String.valueOf(ridgedMultifractal.getLacunarity().getValue()) + ", ";
            script = (String)script + String.valueOf(ridgedMultifractal.getOctaves().getValue()) + ", ";
            script = (String)script + String.valueOf(ridgedMultifractal.getOffset().getValue()) + ", ";
            script = (String)script + String.valueOf(ridgedMultifractal.getGain().getValue()) + ", ";
            script = (String)script + "3) }\n";
            script = (String)script + "  contained_by { sphere { <0, 0, 0>, 1.5 } }\n";
            script = (String)script + "  open\n";
            script = (String)script + "  threshold " + String.valueOf(povIsoSurfaceChromosome.getThreshold().getValue()) + "\n";
            script = (String)script + "  accuracy 0.1\n";
            script = (String)script + "  evaluate 1.1, 1.30, 0.7\n";
            script = (String)script + "}\n";
            script = (String)script + "\n";
        } else {
            script = (String)script + "#declare Thing_1 = sphere { <0, 0, 0>, 1.5 }";
            script = (String)script + "\n";
        }
        script = (String)script + "object {\n";
        script = (String)script + "   Thing_1\n";
        script = (String)script + "   texture {\n";
        script = (String)script + "     Texture1_" + ident + "\n";
        script = (String)script + "   }\n";
        if (normal != null) {
            script = (String)script + "   normal {\n";
            script = (String)script + "     Normal1_" + ident + "\n";
            script = (String)script + "   }\n";
        }
        if (finish != null) {
            script = (String)script + "   finish {\n";
            script = (String)script + "     Finish1_" + ident + "\n";
            script = (String)script + "   }\n";
        }
        script = (String)script + "   scale 1\n";
        if (povThingChromosome instanceof PovIsoSurfaceChromosome) {
            povIsoSurfaceChromosome = (PovIsoSurfaceChromosome)povThingChromosome;
            PovRotateGene rotate = povIsoSurfaceChromosome.getRotate();
            script = (String)script + "   rotate <" + String.valueOf(rotate.getRx().getValue()) + ", " + String.valueOf(rotate.getRy().getValue()) + ", " + String.valueOf(rotate.getRz().getValue()) + ">\n";
        } else {
            script = (String)script + "   rotate <0, 0, 0>\n";
        }
        script = (String)script + "   translate y*0.5\n";
        script = (String)script + "}\n";
        script = (String)script + "\n";
        script = (String)script + "\n";
        script = (String)script + "light_source {\n";
        script = (String)script + "   <0, 4, 0>, rgb <1, 1, 1>\n";
        script = (String)script + "   area_light <1, 0, 0>, <0, 1, 0>, 3, 3\n";
        script = (String)script + "}\n";
        script = (String)script + "\n";
        script = (String)script + "light_source {\n";
        script = (String)script + "   <4, 5, -5>, rgb <1, 1, 1>\n";
        script = (String)script + "}\n";
        script = (String)script + "\n";
        script = (String)script + "camera {\n";
        script = (String)script + "   perspective\n";
        script = (String)script + "   location <2, 3.3, -1.5>\n";
        script = (String)script + "   sky <0, 1, 0>\n";
        script = (String)script + "   direction <0, 0, 1>\n";
        script = (String)script + "   right <1, 0, 0>\n";
        script = (String)script + "   up <0, 1, 0>\n";
        script = (String)script + "  look_at <0, 0.5, 0>\n";
        script = (String)script + "}\n";
        return script;
    }

    private String exTransform(String script, PovTransformMapGene transform) {
        Matrix4X3Gene matrix = transform.getMatrix();
        script = (String)script + "        transform {\n";
        script = (String)script + "          matrix <\n";
        script = (String)script + "            " + String.valueOf(matrix.getVal00().getValue()) + ", " + String.valueOf(matrix.getVal01().getValue()) + ", " + String.valueOf(matrix.getVal02().getValue()) + ",\n";
        script = (String)script + "            " + String.valueOf(matrix.getVal10().getValue()) + ", " + String.valueOf(matrix.getVal11().getValue()) + ", " + String.valueOf(matrix.getVal12().getValue()) + ",\n";
        script = (String)script + "            " + String.valueOf(matrix.getVal20().getValue()) + ", " + String.valueOf(matrix.getVal21().getValue()) + ", " + String.valueOf(matrix.getVal22().getValue()) + ",\n";
        script = (String)script + "            " + String.valueOf(matrix.getVal30().getValue()) + ", " + String.valueOf(matrix.getVal31().getValue()) + ", " + String.valueOf(matrix.getVal32().getValue()) + "\n";
        script = (String)script + "          >\n";
        script = (String)script + (transform.getInvers().isValue() != false ? "          inverse\n" : "");
        script = (String)script + "        }\n";
        return script;
    }

    private String exWarp(String script, PovWarpGene warp) {
        PovTurbulenceWarpGene povWarpGene = warp.getTurbulence();
        script = (String)script + "        warp {\n";
        script = (String)script + "          turbulence\n";
        script = (String)script + "          <" + String.valueOf(povWarpGene.getTurbulenceVector().getX().getValue()) + ", " + String.valueOf(povWarpGene.getTurbulenceVector().getY().getValue()) + ", " + String.valueOf(povWarpGene.getTurbulenceVector().getZ().getValue()) + ">\n";
        script = (String)script + "          omega " + String.valueOf(povWarpGene.getOmega().getValue()) + "\n";
        script = (String)script + "          lambda " + String.valueOf(povWarpGene.getLambda().getValue()) + "\n";
        script = (String)script + "        }\n";
        List<PovBlackHoleWarpGene> blackHoleList = warp.getBlackHole();
        for (PovBlackHoleWarpGene blackHoleWarp : blackHoleList) {
            script = (String)script + "        warp {\n";
            script = (String)script + "          black_hole\n";
            script = (String)script + "          <" + String.valueOf(blackHoleWarp.getLocation().getX().getValue()) + ", " + String.valueOf(blackHoleWarp.getLocation().getY().getValue()) + ", " + String.valueOf(blackHoleWarp.getLocation().getZ().getValue()) + ">, " + String.valueOf(blackHoleWarp.getRadius().getValue()) + "\n";
            script = (String)script + "          falloff " + String.valueOf(blackHoleWarp.getFalloff().getValue()) + "\n";
            script = (String)script + "          strength " + String.valueOf(blackHoleWarp.getStrength().getValue()) + "\n";
            script = (String)script + (blackHoleWarp.getInvers().isValue() != false ? "          inverse\n" : "");
            script = (String)script + "        }\n";
        }
        return script;
    }

    @Override
    protected void showExecError() {
        if ((showExecError & 2) == 0) {
            showExecError = 2;
            JOptionPane.showMessageDialog(Kandid.getFrame(), "<HTML>'" + this.getProgramName() + "' not found.<br><br>POV-Ray 'Persistence of Vision' is required.<br><br>You can get this software and its dependencies as a Debian package.<br><b>povray.deb</b><br><br>The genetic engine inside Kandid can be used as a front end to evolve layered textures for <br>the Persistence of Vision ray tracer. Persistence of Vision acts, behind the scene, as an compiler <br>reading a POV-Ray SDL (Scene Description Language), generated by Kandid, producing images. <br>It is not necessary to edit the parameter files by hand nor starting povray manually. <br>From the users view there is no distinction between the build in and the external calculations.<br><br>The integration of POV-Ray (version 3.7) and Kandid (version 1.1.0) was tested under <br>Debian 13 Trixie using openjdk (version 21.0.8 2025-07-15.)<br><br>http://www.povray.org/", "POV-Ray, additional software reqiered", 0);
        }
    }
}

