/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge.flame;

import java.awt.Dimension;
import java.util.List;
import javax.swing.JOptionPane;
import kandid.Kandid;
import kandid.calculation.bridge.BatchJob;
import kandid.soup.ChromosomeType;
import kandid.soup.FlameIfsChromosome;
import kandid.soup.FlameTransformationGene;

public class FlameJob
extends BatchJob {
    private static final String scriptExtension = ".flam3";

    @Override
    public void createJob(ChromosomeType chromosome, Dimension canvasSize, boolean preview, String exportFilename, String imageFormat) {
        this.canvasSize = canvasSize;
        this.preview = preview;
        this.imageFormat = imageFormat;
        this.doExport = exportFilename != null;
        this.expextedExitCode = 1;
        this.errorMessage = new StringBuffer();
        this.childProgram = this.getProgramName();
        String ident = chromosome.getIdent() + (preview ? "__p" : "__f");
        if (this.doExport) {
            this.scriptFileName = exportFilename + scriptExtension;
            this.imageFileName = exportFilename + "." + imageFormat;
        } else {
            this.scriptFileName = Kandid.scratchFolder + "/" + ident + scriptExtension;
            this.imageFileName = Kandid.scratchFolder + "/" + ident + "." + imageFormat;
        }
        this.script = this.expandScript(chromosome);
        this.comandline = this.buildCommand();
        this.environment = this.buildEnvironment();
        if (firstUsage) {
            firstUsage = false;
            this.tryExecute();
        }
    }

    @Override
    protected String expandScript(ChromosomeType chromosome) {
        FlameIfsChromosome flameIfsChromosome = (FlameIfsChromosome)chromosome;
        String quality = this.preview ? " quality=\"2\"" : " quality=\"20\"";
        String script = "<test>\n<flame time=\"0\" palette=\"" + String.valueOf(flameIfsChromosome.getPalette().getValue()) + "\" size=\"" + this.canvasSize.width / (this.preview ? 3 : 1) + " " + this.canvasSize.height / (this.preview ? 3 : 1) + "\" center=\"0 0\" scale=\"" + 100.0 * ((double)this.canvasSize.width / 1024.0) / (this.preview ? 3.0 : 1.0) + "\" zoom=\"" + String.valueOf(flameIfsChromosome.getZoom().getValue()) + "\" oversample=\"1\" filter=\"" + String.valueOf(flameIfsChromosome.getFilter().getValue()) + "\"" + quality + " batches=\"10\" background=\"0 0 0\" brightness=\"" + String.valueOf(flameIfsChromosome.getBrightness().getValue()) + "\" gamma=\"" + String.valueOf(flameIfsChromosome.getGamma().getValue()) + "\" vibrancy=\"" + String.valueOf(flameIfsChromosome.getVibrancy().getValue()) + "\" hue=\"" + String.valueOf(flameIfsChromosome.getHue().getValue()) + "\">\n";
        List<FlameTransformationGene> flameTransformationList = flameIfsChromosome.getFlameTransformation();
        for (FlameTransformationGene flameTransformation : flameTransformationList) {
            script = script + "   <xform weight=\"" + String.valueOf(flameTransformation.getWeight().getValue()) + "\" color=\"" + String.valueOf(flameTransformation.getColorindex().getValue()) + "\" var=\" " + (flameTransformation.getLinearEnabled().isValue() != false ? flameTransformation.getLinearVariation().getValue() : 0.0) + " " + (flameTransformation.getSinusoidalEnabled().isValue() != false ? flameTransformation.getSinusoidalVariation().getValue() : 0.0) + " " + (flameTransformation.getSphericalEnabled().isValue() != false ? flameTransformation.getSphericalVariation().getValue() : 0.0) + " " + (flameTransformation.getSwirlEnabled().isValue() != false ? flameTransformation.getSwirlVariation().getValue() : 0.0) + " " + (flameTransformation.getHorseshoeEnabled().isValue() != false ? flameTransformation.getHorseshoeVariation().getValue() : 0.0) + " " + (flameTransformation.getPolarEnabled().isValue() != false ? flameTransformation.getPolarVariation().getValue() : 0.0) + " " + (flameTransformation.getFoldedHandkerchiefEnabled().isValue() != false ? flameTransformation.getFoldedHandkerchiefVariation().getValue() : 0.0) + " " + (flameTransformation.getHeartEnabled().isValue() != false ? flameTransformation.getHeartVariation().getValue() : 0.0) + " " + (flameTransformation.getDiscEnabled().isValue() != false ? flameTransformation.getDiscVariation().getValue() : 0.0) + " " + (flameTransformation.getSpiralEnabled().isValue() != false ? flameTransformation.getSpiralVariation().getValue() : 0.0) + " " + (flameTransformation.getHyperbolicEnabled().isValue() != false ? flameTransformation.getHyperbolicVariation().getValue() : 0.0) + " " + (flameTransformation.getDiamondEnabled().isValue() != false ? flameTransformation.getDiamondVariation().getValue() : 0.0) + " " + (flameTransformation.getExEnabled().isValue() != false ? flameTransformation.getExVariation().getValue() : 0.0) + " " + (flameTransformation.getJuliaEnabled().isValue() != false ? flameTransformation.getJuliaVariation().getValue() : 0.0) + " " + (flameTransformation.getBentEnabled().isValue() != false ? flameTransformation.getBentVariation().getValue() : 0.0) + " " + (flameTransformation.getFisheyeEnabled().isValue() != false ? flameTransformation.getFisheyeVariation().getValue() : 0.0) + " " + (flameTransformation.getPopcornEnabled().isValue() != false ? flameTransformation.getPopcornVariation().getValue() : 0.0) + " 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0\" coefs=\"" + String.valueOf(flameTransformation.getTa().getValue()) + " " + String.valueOf(flameTransformation.getTd().getValue()) + " " + String.valueOf(flameTransformation.getTb().getValue()) + " " + String.valueOf(flameTransformation.getTe().getValue()) + " " + String.valueOf(flameTransformation.getTc().getValue()) + " " + String.valueOf(flameTransformation.getTf().getValue()) + "\"/>\n";
        }
        script = script + "</flame>\n";
        script = script + "</test>\n";
        return script;
    }

    @Override
    protected String[] buildEnvironment() {
        String[] envp = new String[]{"in=" + this.scriptFileName, "out=" + this.imageFileName, "format=" + this.imageFormat};
        return envp;
    }

    @Override
    protected String[] buildCommand() {
        String[] command = new String[]{this.childProgram};
        return command;
    }

    @Override
    protected String getScriptExtension() {
        return scriptExtension;
    }

    @Override
    protected String getProgramName() {
        return "flam3-render";
    }

    @Override
    protected void showExecError() {
        if ((showExecError & 1) == 0) {
            showExecError = 1;
            JOptionPane.showMessageDialog(Kandid.getFrame(), "<HTML>'" + this.getProgramName() + "' not found.<br><br>'FLAM3 - cosmic recursive fractal flames' from Scott Draves is required.<br><br>You can get this software and its dependencies as a Debian package.<br><b>flam3-utils.deb</b><br><br>The genetic engine inside Kandid can be used as a front end to evolve flame images.<br>Flame acts, behind the scene, as an compiler reading parameter files, generated by Kandid, <br>producing images. It is not necessary to edit the parameter files by hand nor starting qosmix <br>manually.<br>From the users view there is no distinction between the build in and the external calculations.<br><br>The integration of flam3-render (version 3.1.1+ds2-2+b4) and Kandid (version 1.1.0) was developed under <br>Debian 13 Trixie using openjdk (version 21.0.8 2025-07-15.)<br><br>https://flam3.com/<br>https://github.com/scottdraves/flam3<br>", "FLAM3, additional software reqiered", 0);
        }
    }
}

