/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge;

import kandid.calculation.PixelCalculation;
import kandid.calculation.bridge.Bridge;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;

public abstract class PixelBridgeCalculation
extends PixelCalculation {
    protected boolean ready;
    protected int runCount;
    protected Bridge bbridge;

    @Override
    public boolean reject(ChromosomeType chromosome) {
        this.ready = false;
        return false;
    }

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        this.runCount = 0;
        this.ready = false;
    }

    @Override
    public void calculate(boolean paintOnScreen, String exportFilename) {
        if (paintOnScreen) {
            this.calculateView();
        } else {
            this.calculateExport(exportFilename);
        }
    }

    protected abstract void calculateView();

    public abstract void calculateExport(String var1);

    @Override
    public int getPercent() {
        return -1;
    }

    @Override
    public boolean getReady() {
        return this.ready || this.aborted;
    }

    @Override
    public boolean hasWhiteBackground() {
        return false;
    }

    @Override
    public void setAborted(boolean aborted) {
        super.setAborted(aborted);
        this.aborted = aborted;
        if (this.runCount < 2) {
            this.runCount = 2;
        }
        if (this.bbridge != null) {
            this.bbridge.destroy();
        }
    }
}

