/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import junit.framework.TestCase;
import kandid.calculation.bridge.BridgeBase;
import kandid.calculation.bridge.FileBridge;
import kandid.calculation.bridge.flame.FlameJob;
import kandid.soup.ChromosomeType;
import kandid.soup.PopulationType;
import kandid.soup.test.SoupFactoryTest;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;

public class FileBridgeTest
extends TestCase {
    private static final int height = 200;
    private static final int width = 100;
    SoupFactory soupFactory;
    PopulationType population;
    ChromosomeType aChromosome;
    Dimension dim = new Dimension(100, 200);

    public FileBridgeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.soupFactory = SoupFactory.getSoupFactory();
        this.population = SoupFactoryTest.createRandomPopulation(this.soupFactory, "FlameIfs", "FlameCalculation", "kandid.colorator.RGBColorator");
        this.aChromosome = this.soupFactory.getChromosome(this.population, 0);
        this.dim = new Dimension(100, 200);
    }

    public void testTryNice() {
        FileBridgeTest.assertEquals((boolean)true, (boolean)BridgeBase.tryNice());
    }

    public void testExecute() {
        FlameJob flameJob = new FlameJob();
        flameJob.createJob(this.aChromosome, this.dim, false, null, "png");
        FileBridge fileBridge = new FileBridge(flameJob);
        fileBridge.execute();
        fileBridge.waitFor();
        FileBridgeTest.assertEquals((int)2, (int)flameJob.state);
        BufferedImage image = null;
        try {
            image = fileBridge.getImage();
        }
        catch (IOException exc) {
            Debug.stackTrace(exc);
            FileBridgeTest.fail();
        }
        FileBridgeTest.assertNotNull((Object)image);
        FileBridgeTest.assertEquals((int)200, (int)image.getHeight());
        FileBridgeTest.assertEquals((int)100, (int)image.getWidth());
    }

    public void testDestroy() {
        FlameJob flameJob = new FlameJob();
        flameJob.createJob(this.aChromosome, this.dim, false, null, "png");
        FileBridge fileBridge = new FileBridge(flameJob);
        fileBridge.execute();
        fileBridge.destroy();
        FileBridgeTest.assertEquals((int)3, (int)flameJob.state);
        BufferedImage image = null;
        try {
            image = fileBridge.getImage();
        }
        catch (IOException exc) {
            Debug.stackTrace(exc);
            FileBridgeTest.fail();
        }
        FileBridgeTest.assertNull((Object)image);
    }

    public void testErrorMessage() {
        FlameJob flameJob = new FlameJob();
        flameJob.createJob(this.aChromosome, this.dim, false, null, "png");
        flameJob.script = flameJob.script.replace('<', '!');
        FileBridge fileBridge = new FileBridge(flameJob);
        fileBridge.execute();
        fileBridge.waitFor();
        FileBridgeTest.assertTrue((flameJob.errorMessage.length() >= 0 ? 1 : 0) != 0);
        System.out.println(flameJob.errorMessage.toString());
        FileBridgeTest.assertTrue((boolean)flameJob.errorMessage.toString().contains("Failed to parse"));
    }
}

