/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import kandid.Console;
import kandid.Kandid;
import kandid.calculation.bridge.BatchJob;
import kandid.calculation.bridge.StderrReader;
import kandid.util.Debug;

public abstract class BridgeBase {
    protected BatchJob batchJob;
    protected Process childProcess;
    public static final int previewScale = 3;
    protected AffineTransform scale;
    protected static boolean niceFound = false;
    private static boolean niceTest = false;

    public BridgeBase(BatchJob batchJob) {
        this.batchJob = batchJob;
        this.scale = new AffineTransform();
        this.scale.setToScale(3.0, 3.0);
        File scratchDir = new File(Kandid.scratchFolder);
        if (!scratchDir.exists()) {
            scratchDir.mkdirs();
        }
    }

    public abstract BufferedImage getImage() throws IOException;

    public abstract void cleanUp();

    public synchronized void execute() {
        try {
            this.writeScript();
        }
        catch (IOException exc) {
            this.batchJob.state = 3;
            Debug.stackTrace(exc);
            return;
        }
        try {
            if (this.batchJob.environment == null && BridgeBase.tryNice()) {
                String[] niceCmd = new String[2 + this.batchJob.comandline.length];
                niceCmd[0] = "nice";
                niceCmd[1] = "-5";
                int px = 0;
                while (px < this.batchJob.comandline.length) {
                    niceCmd[2 + px] = this.batchJob.comandline[px];
                    ++px;
                }
                this.childProcess = Runtime.getRuntime().exec(niceCmd, this.batchJob.environment);
            } else {
                this.childProcess = Runtime.getRuntime().exec(this.batchJob.comandline, this.batchJob.environment);
            }
            this.batchJob.state = 1;
            new StderrReader(this.childProcess, this.batchJob).start();
        }
        catch (IOException exc) {
            this.batchJob.state = 3;
            Debug.stackTrace(exc);
            this.batchJob.showExecError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void waitFor() {
        if (this.batchJob.state != 1 && this.batchJob.state != 2) return;
        try {
            try {
                if (this.childProcess != null) {
                    this.batchJob.exitCode = this.childProcess.waitFor();
                    if (this.batchJob.state != 1) return;
                    this.batchJob.state = 2;
                    return;
                } else {
                    this.batchJob.state = 3;
                }
                return;
            }
            catch (InterruptedException exc) {
                this.batchJob.state = 3;
                this.batchJob.exitCode = -7;
                this.childProcess = null;
                if (this.batchJob.exitCode != this.batchJob.expextedExitCode) {
                    // empty if block
                }
                if (this.batchJob.errorMessage.length() <= 0) return;
                Console.append(this.batchJob.errorMessage.toString());
                return;
            }
            catch (Throwable exc) {
                this.batchJob.state = 3;
                this.batchJob.exitCode = -8;
                Debug.stackTrace(exc);
                this.childProcess = null;
                if (this.batchJob.exitCode != this.batchJob.expextedExitCode) {
                    // empty if block
                }
                if (this.batchJob.errorMessage.length() <= 0) return;
                Console.append(this.batchJob.errorMessage.toString());
                return;
            }
        }
        finally {
            this.childProcess = null;
            if (this.batchJob.exitCode != this.batchJob.expextedExitCode) {
                // empty if block
            }
            if (this.batchJob.errorMessage.length() > 0) {
                Console.append(this.batchJob.errorMessage.toString());
            }
        }
    }

    public synchronized void destroy() {
        if (this.batchJob.state == 1) {
            this.batchJob.state = 3;
            if (this.childProcess != null) {
                this.childProcess.destroy();
                this.childProcess = null;
            }
        }
        this.batchJob.state = 3;
        this.cleanUp();
    }

    public static boolean tryNice() {
        if (!niceTest) {
            niceTest = true;
            try {
                String[] cmdarray = new String[]{"nice"};
                Process childProcess = Runtime.getRuntime().exec(cmdarray);
                niceFound = true;
                if (childProcess != null) {
                    childProcess.destroy();
                }
                System.out.println("detecting nice command for external processes");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return niceFound;
    }

    protected void writeScript() throws IOException {
        FileWriter fileWriter = new FileWriter(new File(this.batchJob.scriptFileName));
        fileWriter.write(this.batchJob.script);
        fileWriter.close();
    }
}

