/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.bridge;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import kandid.Kandid;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public abstract class BatchJob {
    public static final int statePending = 0;
    public static final int stateRunning = 1;
    public static final int stateReady = 2;
    public static final int stateDestroied = 3;
    public int state = 0;
    public String childProgram;
    public String[] comandline;
    public String[] environment;
    public String script;
    public String scriptFileName;
    public String imageFileName;
    public String imageFormat;
    public boolean doExport;
    public Dimension canvasSize;
    public boolean preview;
    public Object sync;
    public int exitCode;
    public int expextedExitCode;
    public StringBuffer errorMessage = new StringBuffer();
    public Object incrementReady = new Object();
    public BufferedImage importedImage;
    protected static boolean firstUsage = true;
    protected static int showExecError = 0;

    protected abstract String[] buildCommand();

    protected abstract String[] buildEnvironment();

    protected abstract String expandScript(ChromosomeType var1);

    protected abstract String getProgramName();

    protected abstract String getScriptExtension();

    protected abstract void showExecError();

    public void createJob(ChromosomeType chromosome, Dimension canvasSize, boolean preview, String exportFilename, String imageFormat) {
        this.canvasSize = canvasSize;
        this.preview = preview;
        this.imageFormat = imageFormat;
        this.doExport = exportFilename != null;
        this.expextedExitCode = 1;
        this.errorMessage = new StringBuffer();
        this.childProgram = this.getProgramName();
        String ident = chromosome.getIdent() + (preview ? "__p" : "__f");
        if (this.doExport) {
            this.scriptFileName = exportFilename + this.getScriptExtension();
            this.imageFileName = exportFilename + "." + imageFormat;
        } else {
            this.scriptFileName = Kandid.scratchFolder + "/" + ident + this.getScriptExtension();
            this.imageFileName = Kandid.scratchFolder + "/" + ident + "." + imageFormat;
        }
        this.script = this.expandScript(chromosome);
        this.comandline = this.buildCommand();
        this.environment = this.buildEnvironment();
        if (firstUsage) {
            firstUsage = false;
            this.tryExecute();
        }
    }

    public boolean tryExecute() {
        Process childProcess = null;
        boolean found = false;
        try {
            String[] cmdarray = new String[]{this.getProgramName()};
            childProcess = Runtime.getRuntime().exec(cmdarray);
            found = true;
        }
        catch (IOException exc) {
            Debug.stackTrace(exc);
            this.showExecError();
        }
        if (childProcess != null) {
            childProcess.destroy();
        }
        return found;
    }
}

