/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.affineifs;

import java.util.List;
import java.util.Random;
import kandid.calculation.IterationCalculation;
import kandid.colorator.BlackWhiteColorator;
import kandid.colorator.Colorator;
import kandid.colorator.GrayColorator;
import kandid.soup.AffineIfsChromosome;
import kandid.soup.AffineTransformationGene;
import kandid.soup.ChromosomeType;
import kandid.util.Util;

public class AffineIfsCalculation
extends IterationCalculation
implements Cloneable {
    protected Random rand = new Random();
    protected int maxTransformations = 8;
    protected int numTransformations;
    private double[] mTa = new double[this.maxTransformations];
    private double[] mTb = new double[this.maxTransformations];
    private double[] mTc = new double[this.maxTransformations];
    private double[] mTd = new double[this.maxTransformations];
    private double[] mTe = new double[this.maxTransformations];
    private double[] mTf = new double[this.maxTransformations];
    private static final int maxMatcher = 128;
    private int[] matcher = new int[128];

    @Override
    protected int getMaxIterations(int width, int height) {
        if (this.colorator instanceof BlackWhiteColorator) {
            return 8 * this.canvasSize.width * this.canvasSize.height;
        }
        if (this.colorator instanceof GrayColorator) {
            return 16 * this.canvasSize.width * this.canvasSize.height;
        }
        return 64 * this.canvasSize.width * this.canvasSize.height;
    }

    @Override
    public boolean reject(ChromosomeType chromosome) {
        this.chromosome = chromosome;
        this.prepareMatcher((AffineIfsChromosome)chromosome);
        this.startIteration();
        this.findExtremeValues(5000);
        return this.xmin < -1000.0 || this.xmax > 1000.0 || this.ymin < -1000.0 || this.ymax > 1000.0;
    }

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        this.prepareMatcher((AffineIfsChromosome)chromosome);
    }

    protected void prepareMatcher(AffineIfsChromosome ifsChromosome) {
        List<AffineTransformationGene> transformationList = ifsChromosome.getAffineTransformation();
        this.numTransformations = transformationList.size();
        double[] P = new double[this.maxTransformations];
        this.rand.setSeed(ifsChromosome.getSeed().getValue());
        double sum = 0.0;
        int ax = 0;
        while (ax < this.numTransformations) {
            AffineTransformationGene afGene = transformationList.get(ax);
            double[] result = Util.polar2matrix(afGene.getTa().getValue(), afGene.getTb().getValue(), afGene.getTc().getValue(), afGene.getTd().getValue(), afGene.getTe().getValue(), afGene.getTf().getValue());
            this.mTa[ax] = result[0];
            this.mTb[ax] = result[1];
            this.mTc[ax] = result[2];
            this.mTd[ax] = result[3];
            this.mTe[ax] = result[4];
            this.mTf[ax] = result[5];
            ++ax;
        }
        ax = 0;
        while (ax < this.maxTransformations) {
            P[ax] = 0.0;
            ++ax;
        }
        ax = 0;
        while (ax < this.numTransformations) {
            P[ax] = Math.abs(this.mTa[ax] * this.mTd[ax] - this.mTb[ax] * this.mTc[ax]);
            if (P[ax] < 0.01) {
                P[ax] = 0.01;
            }
            sum += P[ax];
            ++ax;
        }
        P[0] = P[0] / sum;
        P[1] = P[1] / sum;
        P[2] = P[2] / sum;
        P[3] = P[3] / sum;
        P[4] = P[4] / sum;
        P[5] = P[5] / sum;
        P[6] = P[6] / sum;
        P[7] = P[7] / sum;
        double trigger = 0.0;
        int cx = 0;
        while (cx < 128) {
            this.matcher[cx] = trigger < P[0] ? 0 : (trigger < P[0] + P[1] ? 1 : (trigger < P[0] + P[1] + P[2] ? 2 : (trigger < P[0] + P[1] + P[2] + P[3] ? 3 : (trigger < P[0] + P[1] + P[2] + P[3] + P[4] ? 4 : (trigger < P[0] + P[1] + P[2] + P[3] + P[4] + P[5] ? 5 : (trigger < P[0] + P[1] + P[2] + P[3] + P[4] + P[5] + P[6] ? 6 : 7))))));
            trigger += 0.0078125;
            ++cx;
        }
    }

    @Override
    protected void iterate() {
        int tx = this.numTransformations > 1 ? this.matcher[this.rand.nextInt(128)] : 0;
        double x2 = this.xw * this.mTa[tx] + this.yw * this.mTb[tx] + this.mTe[tx];
        double y2 = this.xw * this.mTc[tx] + this.yw * this.mTd[tx] + this.mTf[tx];
        this.xw = x2;
        this.yw = y2;
    }

    @Override
    public boolean hasWhiteBackground() {
        return true;
    }
}

