/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation;

import java.awt.Component;
import java.awt.Dimension;
import kandid.calculation.PixelCalculation;
import kandid.colorator.ColorF32;

public abstract class WorldCalculation
extends PixelCalculation
implements Cloneable {
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected double xfactor;
    protected double yfactor;
    protected double xw;
    protected double yw;
    protected int xp;
    protected int yp;

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        this.ymin = 0.0;
        this.xmin = 0.0;
        this.ymax = 1.0;
        this.xmax = 1.0;
        this.xfactor = canvasSize.width;
        this.yfactor = canvasSize.height;
        this.yp = 0;
        this.xp = 0;
    }

    protected void initTransformation(double borderFactor) {
        double xBorder = borderFactor * (this.xmax - this.xmin);
        double yBorder = borderFactor * (this.ymax - this.ymin);
        this.xmax += xBorder;
        this.xmin -= xBorder;
        this.ymax += yBorder;
        this.ymin -= yBorder;
        double diffX = this.xmax - this.xmin;
        double diffY = this.ymax - this.ymin;
        if (diffX > 0.0) {
            this.xfactor = (double)this.canvasSize.width / diffX;
        }
        if (diffY > 0.0) {
            this.yfactor = (double)this.canvasSize.height / diffY;
        }
    }

    protected void setWPixel(ColorF32 colorF32) {
        this.xp = (int)((this.xw - this.xmin) * this.xfactor);
        this.yp = (int)((this.yw - this.ymin) * this.yfactor);
        try {
            this.bufAwtImg.setRGB(this.xp, this.yp, ColorF32.toRGB8(colorF32));
            ColorF32.copy(colorF32, this.bufColorF32Img[this.yp][this.xp]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void transform() {
        this.xp = (int)((this.xw - this.xmin) * this.xfactor);
        this.yp = (int)((this.yw - this.ymin) * this.yfactor);
    }
}

