/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import kandid.calculation.Calculation;
import kandid.colorator.ColorF32;
import kandid.extensions.ExportState;
import kandid.util.Debug;

public abstract class PixelCalculation
extends Calculation
implements Cloneable {
    protected int size;
    protected BufferedImage bufAwtImg;
    protected ColorF32[][] bufColorF32Img;
    protected AffineTransform affineTransform;

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        this.affineTransform = new AffineTransform();
        this.affineTransform.setToIdentity();
        this.bufAwtImg = new BufferedImage(canvasSize.width, canvasSize.height, 1);
        this.bufColorF32Img = new ColorF32[canvasSize.height][];
        int iy = 0;
        while (iy < canvasSize.height) {
            this.bufColorF32Img[iy] = new ColorF32[canvasSize.width];
            int ix = 0;
            while (ix < canvasSize.width) {
                this.bufColorF32Img[iy][ix] = new ColorF32();
                ++ix;
            }
            ++iy;
        }
    }

    public BufferedImage getImage() {
        return this.bufAwtImg;
    }

    protected void setPixel(int xp, int yp, ColorF32 colorF32) {
        try {
            this.bufAwtImg.setRGB(xp, yp, ColorF32.toRGB8(colorF32));
            ColorF32.copy(colorF32, this.bufColorF32Img[yp][xp]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public void writeRGB_PNG16(ExportState exportState, File imageOutFile) {
        ImageInfo image_info = new ImageInfo(exportState.xDim, exportState.yDim, 16, false);
        PngWriter png_writer = new PngWriter(imageOutFile, image_info);
        ImageLineInt line = new ImageLineInt(image_info);
        int[] scanline = line.getScanline();
        int yp = 0;
        while (yp < exportState.yDim) {
            int j = 0;
            int xp = 0;
            while (xp < exportState.xDim) {
                scanline[j++] = (int)(this.bufColorF32Img[yp][xp].r * 65535.0f);
                scanline[j++] = (int)(this.bufColorF32Img[yp][xp].g * 65535.0f);
                scanline[j++] = (int)(this.bufColorF32Img[yp][xp].b * 65535.0f);
                ++xp;
            }
            png_writer.writeRow((IImageLine)line, yp);
            ++yp;
        }
        png_writer.end();
    }

    public void writeRGB_PFM(ExportState exportState, File imageOutFile) {
        block16: {
            FileOutputStream out = null;
            PrintWriter header_out = null;
            DataOutputStream data_out = null;
            try {
                try {
                    out = new FileOutputStream(imageOutFile);
                    header_out = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.US_ASCII));
                    header_out.print("PF\n");
                    header_out.print(exportState.xDim + " " + exportState.yDim + "\n");
                    header_out.print("-1.0\n");
                    header_out.flush();
                    data_out = new DataOutputStream(out);
                    int yp = exportState.yDim - 1;
                    while (yp >= 0) {
                        int xp = 0;
                        while (xp < exportState.xDim) {
                            data_out.writeInt(Integer.reverseBytes(Float.floatToIntBits(this.bufColorF32Img[yp][xp].r)));
                            data_out.writeInt(Integer.reverseBytes(Float.floatToIntBits(this.bufColorF32Img[yp][xp].g)));
                            data_out.writeInt(Integer.reverseBytes(Float.floatToIntBits(this.bufColorF32Img[yp][xp].b)));
                            ++xp;
                        }
                        --yp;
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                    Debug.stackTrace(exc);
                    if (header_out != null) {
                        header_out.close();
                    }
                    if (out == null) break block16;
                    try {
                        out.close();
                    }
                    catch (IOException exc2) {
                        exc2.printStackTrace();
                        Debug.stackTrace(exc2);
                    }
                }
            }
            finally {
                if (header_out != null) {
                    header_out.close();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                        Debug.stackTrace(exc);
                    }
                }
            }
        }
    }

    public void writeRGB_JPG(File imageOutFile) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam params = writer.getDefaultWriteParam();
        params.setCompressionMode(2);
        params.setCompressionQuality(1.0f);
        try {
            FileImageOutputStream output = new FileImageOutputStream(imageOutFile);
            writer.setOutput(output);
            IIOImage image = new IIOImage(this.bufAwtImg, null, null);
            writer.write(null, image, params);
            writer.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object clone() {
        PixelCalculation calc = null;
        calc = (PixelCalculation)super.clone();
        return calc;
    }
}

