/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import kandid.calculation.WorldCalculation;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.util.Weight;

public abstract class IterationCalculation
extends WorldCalculation
implements Cloneable {
    private int actCount;
    private int maxCount;
    private int countState;
    protected ColorF32 pointColor;
    protected Weight weight;

    @Override
    public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
        super.setChromosome(chromosome, colorator);
        this.pointColor = ColorF32.black;
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        this.startIteration();
        this.findExtremeValues(7500);
        this.initTransformation(0.1);
        this.maxCount = this.actCount = this.getMaxIterations(canvasSize.width, canvasSize.height);
        this.countState = 0;
        Graphics gr = this.bufAwtImg.getGraphics();
        gr.setColor(this.hasWhiteBackground() ? Color.white : Color.black);
        gr.fillRect(0, 0, canvasSize.width, canvasSize.height);
    }

    protected void prepareWeight() {
        this.weight = new Weight(this.canvasSize.width, this.canvasSize.height, this.colorator);
    }

    private int nextRun(boolean paintOnScreen) {
        if (paintOnScreen) {
            int count = 625000;
            switch (this.countState) {
                case 0: {
                    count = 25000;
                    ++this.countState;
                    break;
                }
                case 1: {
                    count = 125000;
                    ++this.countState;
                }
            }
            if (count > this.actCount) {
                count = this.actCount;
                this.actCount = 0;
            } else {
                this.actCount -= count;
            }
            return count;
        }
        this.actCount = 0;
        return this.maxCount;
    }

    @Override
    public void calculate(boolean paintOnScreen, String doExport) {
        int count = this.nextRun(paintOnScreen);
        while (count > 0) {
            this.iterate();
            this.setWPixel(this.pointColor);
            --count;
        }
    }

    protected void calculateWeight(boolean paintOnScreen) {
        int count = this.nextRun(paintOnScreen);
        while (count > 0) {
            this.iterate();
            this.transform();
            this.weight.inc(this.xp, this.yp);
            --count;
        }
        this.weight.toImageLog(this.bufAwtImg, this.bufColorF32Img);
    }

    @Override
    public boolean getReady() {
        return this.aborted || this.actCount <= 0;
    }

    @Override
    public int getPercent() {
        return 100 * (this.maxCount - this.actCount) / this.maxCount;
    }

    protected void findExtremeValues(int iterations) {
        this.xmin = Double.MAX_VALUE;
        this.xmax = Double.MIN_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.ymax = Double.MIN_VALUE;
        while (--iterations > 0) {
            this.iterate();
            if (this.xw < this.xmin) {
                this.xmin = this.xw;
            }
            if (this.yw < this.ymin) {
                this.ymin = this.yw;
            }
            if (this.xw > this.xmax) {
                this.xmax = this.xw;
            }
            if (!(this.yw > this.ymax)) continue;
            this.ymax = this.yw;
        }
    }

    protected void startIteration() {
        this.xw = 0.5;
        this.yw = 0.5;
        int ix = 0;
        while (ix < 50) {
            this.iterate();
            ++ix;
        }
    }

    protected abstract void iterate();

    protected abstract int getMaxIterations(int var1, int var2);
}

