/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import kandid.Gateway;
import kandid.OrganismPanel;
import kandid.SwingWorker;
import kandid.calculation.Calculation;
import kandid.colorator.Colorator;
import kandid.pond.ui.IlPool;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public class ViewEngine
extends JLabel
implements Runnable,
Scrollable {
    private static final long serialVersionUID = 1L;
    private static final Dimension scrDim = Toolkit.getDefaultToolkit().getScreenSize();
    public static final int zoomWidth = 1024;
    private static final int zoomHeight = 1024;
    private Dimension dim;
    private boolean zoomMode;
    private int nRows;
    private int nCols;
    private Thread engine;
    private Object sync = new Object();
    private Gateway gateway;
    private boolean ready;
    private OrganismPanel organismPanel;
    private IlPool ilPool;

    public ViewEngine(int size, int nRows, int nCols, OrganismPanel organismPanel, IlPool ilPool) {
        this.zoomMode = size > 200;
        this.nRows = nRows;
        this.nCols = nCols;
        this.organismPanel = organismPanel;
        this.ilPool = ilPool;
        this.gateway = new Gateway();
        this.calcDimension(size);
        this.setHorizontalAlignment(0);
    }

    private void calcDimension(int size) {
        int yl;
        int xl;
        this.dim = size > 0 ? new Dimension(size, size) : ((xl = (ViewEngine.scrDim.width - 41) / this.nCols) < (yl = (ViewEngine.scrDim.height - (this.nRows * 25 + 50)) / this.nRows) ? new Dimension(xl, xl) : new Dimension(yl, yl));
        this.setPreferredSize(this.dim);
        this.setMaximumSize(this.dim);
        this.setMinimumSize(this.dim);
        this.setSize(this.dim);
    }

    public void prepare(ChromosomeType chromosome, Calculation calculation, Colorator colorator) {
        this.gateway.setChromosome(chromosome, calculation, colorator);
        if (this.zoomMode) {
            Dimension prefDim = this.gateway.getCalculation().getPreferredSize();
            if (prefDim != null) {
                if (prefDim.width < 125) {
                    prefDim.width = 125;
                }
                if (prefDim.height < 125) {
                    prefDim.height = 125;
                }
                this.dim = prefDim;
            } else {
                this.dim = new Dimension(1024, 1024);
            }
        }
        this.setPreferredSize(this.dim);
        this.setMaximumSize(this.dim);
        this.setMinimumSize(this.dim);
        this.setSize(this.dim);
        this.gateway.activateScreenCanvas(this.dim, this, this.zoomMode);
        ImageIcon imageViewImageIcon = new ImageIcon(this.gateway.getImage());
        this.setIcon(imageViewImageIcon);
    }

    public void start() {
        if (this.engine != null) {
            if (this.engine.isAlive()) {
                this.engine.interrupt();
            }
            this.engine = null;
        }
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
        }
        if (this.organismPanel != null) {
            this.organismPanel.restartAnimation();
        }
    }

    public void stop() {
        if (this.engine != null) {
            try {
                if (this.engine.isAlive()) {
                    this.gateway.getCalculation().setAborted(true);
                    this.engine.interrupt();
                }
            }
            catch (Throwable exc) {
                Debug.stackTrace(exc);
            }
            this.engine = null;
        }
        if (this.organismPanel != null) {
            this.organismPanel.hideStopButton();
            this.organismPanel.stopAnimation();
        }
    }

    public void command(int cmd) {
        this.gateway.getCalculation().command(cmd);
    }

    public Calculation getCalculation() {
        return this.gateway.getCalculation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        Thread me = Thread.currentThread();
        me.setPriority(1 + (this.zoomMode ? 2 : 1));
        while (!this.gateway.getReady() && this.engine == me && !Thread.currentThread().isInterrupted()) {
            Object worker;
            this.ready = false;
            if (!this.gateway.getDeferred()) {
                worker = new Worker(this);
                ((SwingWorker)worker).start();
            }
            try {
                worker = this.sync;
                synchronized (worker) {
                    while (!this.ready) {
                        this.sync.wait();
                    }
                }
            }
            catch (InterruptedException exc) {
                return;
            }
        }
        if (this.organismPanel != null) {
            this.organismPanel.hideStopButton();
            this.organismPanel.stopAnimation();
            this.organismPanel.getPopulationController().notifyReady(this.organismPanel.getPopulationID());
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public OrganismPanel getOrganismPanel() {
        return this.organismPanel;
    }

    public IlPool getPoolController() {
        return this.ilPool;
    }

    public boolean isZoomMode() {
        return this.zoomMode;
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    public Dimension getDim() {
        return this.dim;
    }

    private class Worker
    extends SwingWorker {
        ViewEngine viewEngine;

        public Worker(ViewEngine viewEngine2) {
            this.viewEngine = viewEngine2;
        }

        @Override
        public Object construct() {
            try {
                ViewEngine.this.gateway.calculate(true, null);
            }
            catch (Throwable exc) {
                Debug.stackTrace(exc);
            }
            return ViewEngine.this.gateway;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            try {
                ViewEngine.this.gateway.updateImage(this.viewEngine);
            }
            catch (Throwable exc) {
                Debug.stackTrace(exc);
            }
            Object object = ViewEngine.this.sync;
            synchronized (object) {
                ViewEngine.this.ready = true;
                ViewEngine.this.sync.notify();
            }
        }
    }
}

