/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import kandid.ViewEngine;
import kandid.extensions.LRUImageCache;
import kandid.pond.ui.IlPool;
import kandid.soup.ChromosomeType;
import kandid.soup.EntityType;
import kandid.soup.ImageType;
import kandid.soup.PopulationType;
import kandid.soup.RatingBase;
import kandid.soup.util.ChromosomeStamp;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;

public class ImageTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private boolean sendToPool;

    public ImageTransferHandler(boolean sendToPool) {
        this.sendToPool = sendToPool;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new StringSelection(this.exportString(c));
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                return this.importString(c, str);
            }
            catch (UnsupportedFlavorException ufe) {
                Debug.stackTrace(ufe);
            }
            catch (IOException ioe) {
                Debug.stackTrace(ioe);
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (DataFlavor.stringFlavor.equals(flavors[i]) && c != null) {
                if (this.sendToPool) {
                    return true;
                }
                if (c instanceof ViewEngine) {
                    ViewEngine viewEngine = (ViewEngine)c;
                    if ((this.sendToPool || viewEngine.getCalculation().getFitness().abort) && !viewEngine.isZoomMode()) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    protected String exportString(JComponent c) {
        if (c != null && c instanceof ViewEngine) {
            ViewEngine viewEngine = (ViewEngine)c;
            SoupFactory soupFactory = SoupFactory.getSoupFactory();
            EntityType entity = null;
            if (viewEngine.getOrganismPanel() != null) {
                int id = viewEngine.getOrganismPanel().getPopulationID();
                PopulationType population = viewEngine.getOrganismPanel().getPopulationController().getPopulation();
                ImageType image = soupFactory.getImage(population, id);
                entity = soupFactory.createEntity(image);
            } else if (viewEngine.getPoolController() != null) {
                IlPool ilPool = viewEngine.getPoolController();
                entity = ilPool.getEntity(viewEngine);
            }
            return soupFactory.marshalToString(entity);
        }
        return "";
    }

    protected boolean importString(JComponent c, String stringRepresentation) {
        SoupFactory soupFactory;
        Object input;
        if (c != null && (input = (soupFactory = SoupFactory.getSoupFactory()).unmarshalFromString(stringRepresentation)) != null && input instanceof EntityType) {
            ViewEngine viewEngine;
            PopulationType population;
            String destinationTypeName;
            EntityType entity = (EntityType)input;
            String sourceTypeName = SoupFactory.getTypeName(entity);
            if (this.sendToPool) {
                ImageType image = soupFactory.getImage(entity);
                image.setRating(RatingBase.NONE);
                IlPool.getInstance().addImage(image);
                return true;
            }
            if (c instanceof ViewEngine && sourceTypeName.equals(destinationTypeName = SoupFactory.getTypeName(population = (viewEngine = (ViewEngine)c).getOrganismPanel().getPopulationController().getPopulation()))) {
                ImageType image = soupFactory.getImage(entity);
                image.setRating(RatingBase.NONE);
                ChromosomeType chromosome = soupFactory.getChromosome(entity);
                String oldId = chromosome.getIdent();
                String newId = ChromosomeStamp.forceNextChromosomeId(chromosome.getIdent());
                chromosome.setIdent(newId);
                LRUImageCache.getLRUImageCache().duplicate(oldId, newId);
                int ix = viewEngine.getOrganismPanel().getPopulationID();
                soupFactory.replaceImage(population, ix, image);
                viewEngine.getOrganismPanel().getPopulationController().apply(ix);
                return true;
            }
        }
        return false;
    }
}

