/*
 * Decompiled with CFR 0.152.
 */
package kandid;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kandid.Environment;
import kandid.Kandid;

public class EnvironmentEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ImageIcon cancelImageIcon;
    private static ImageIcon acceptImageIcon;
    private Environment environment;
    private boolean valid;
    private JPanel inputPanel;
    private JLabel crossingoverLabel;
    private JTextField crossingoverTextField;
    private JLabel mutationLabel;
    private JTextField mutationTextField;
    private JLabel scaleLabel;
    private JTextField scaleTextField;
    private JPanel controlPanel;
    private JButton cancelButton;
    private JButton okButton;

    public EnvironmentEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initComponents() {
        this.inputPanel = new JPanel();
        this.crossingoverLabel = new JLabel();
        this.crossingoverTextField = new JTextField();
        this.mutationLabel = new JLabel();
        this.mutationTextField = new JTextField();
        this.scaleLabel = new JLabel();
        this.scaleTextField = new JTextField();
        this.controlPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setTitle("Environment Editor");
        this.setName("EnvironmentEditor");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EnvironmentEditor.this.closeDialog(evt);
            }
        });
        this.inputPanel.setLayout(new GridLayout(3, 2));
        this.crossingoverLabel.setText("crossing over rate:   ");
        this.inputPanel.add(this.crossingoverLabel);
        this.inputPanel.add(this.crossingoverTextField);
        this.mutationLabel.setText("mutation rate:   ");
        this.inputPanel.add(this.mutationLabel);
        this.inputPanel.add(this.mutationTextField);
        this.scaleLabel.setText("scale factor:   ");
        this.inputPanel.add(this.scaleLabel);
        this.inputPanel.add(this.scaleTextField);
        this.getContentPane().add((Component)this.inputPanel, "Center");
        this.controlPanel.setLayout(new FlowLayout(2));
        if (acceptImageIcon == null) {
            acceptImageIcon = Kandid.getInstance().createImageIcon("accept.png", null);
        }
        this.okButton.setIcon(acceptImageIcon);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnvironmentEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.okButton);
        if (cancelImageIcon == null) {
            cancelImageIcon = Kandid.getInstance().createImageIcon("cancel.png", null);
        }
        this.cancelButton.setIcon(cancelImageIcon);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnvironmentEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.valid = true;
        this.close();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.valid = false;
        this.close();
    }

    private void closeDialog(WindowEvent evt) {
        this.valid = false;
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new EnvironmentEditor((Frame)new JFrame(), true).setVisible(true);
    }

    public Environment getEnvironment() {
        if (this.valid) {
            try {
                this.environment.setMergeRate(Double.parseDouble(this.crossingoverTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.environment.setMutationRate(Double.parseDouble(this.mutationTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.environment.setScaleFactor(Double.parseDouble(this.scaleTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        this.crossingoverTextField.setText("" + environment.getMergeRate());
        this.mutationTextField.setText("" + environment.getMutationRate());
        this.scaleTextField.setText("" + environment.getScaleFactor());
    }
}

